/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker.audio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;

public final class FrameHeader {
    public static final int BYTES = 32;
    public static final int MAGIC = 0x54415544;
    public static final byte VERSION = 1;
    public static final byte FLAG_ENCRYPTED = 1;
    public byte version = 1;
    public byte flags = 0;
    public UUID streamId;
    public int frameSeq;
    public int payloadLength;

    public static void write(ByteBuffer bb, FrameHeader h) {
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.putInt(0x54415544);
        bb.put(h.version);
        bb.put(h.flags);
        bb.putShort((short)0);
        bb.putLong(h.streamId.getMostSignificantBits());
        bb.putLong(h.streamId.getLeastSignificantBits());
        bb.putInt(h.frameSeq);
        bb.putInt(h.payloadLength);
    }

    public static FrameHeader read(ByteBuffer bb) {
        bb.order(ByteOrder.BIG_ENDIAN);
        int magic = bb.getInt();
        if (magic != 0x54415544) {
            throw new IllegalStateException("Bad magic: " + Integer.toHexString(magic));
        }
        FrameHeader h = new FrameHeader();
        h.version = bb.get();
        if (h.version != 1) {
            throw new IllegalStateException("Unsupported version: " + h.version);
        }
        h.flags = bb.get();
        bb.getShort();
        long msb = bb.getLong();
        long lsb = bb.getLong();
        h.streamId = new UUID(msb, lsb);
        h.frameSeq = bb.getInt();
        h.payloadLength = bb.getInt();
        return h;
    }
}

